//
//  MCAlertRegistry.h
//  MCFoundation
//
//  Created by Michael Clark on 04/12/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCAlertRegistry : NSObject {
	
	NSMutableDictionary*        __typeConfigs;  // Indexed by typeCode
	NSMutableDictionary*        __entityConfigs; // Indexed by entityName - then Indexed by typeCode
}

+ (MCAlertRegistry*)defaultRegistry;


- (void)loadConfigurationAtPath: (NSString*)path;


- (NSDictionary*)configForEntityNamed: (NSString*)anEntityName andTypeCode: (NSNumber*)aTypeCode;



- (NSMutableDictionary *)typeConfigs;
- (void)setTypeConfigs:(NSMutableDictionary *)aTypeConfigs;
- (NSMutableDictionary *)entityConfigs;
- (void)setEntityConfigs:(NSMutableDictionary *)anEntityConfigs;

// Array of possible alert types, localized
- (NSArray *)localizedReasonKeys;
@end
